$(document).ready(function () {
	$(".owl-partners").owlCarousel({
		navigation: false, // Show next and prev buttons
		slideSpeed: 300,
		paginationSpeed: 400,
		singleItem: true,
		autoPlay: 10000,
		pagination: false,
		transitionStyle: "fadeUp"
	});

	resizeImages();

	$('.to-hide').css('display', 'none');
});

window.onresize = function(event) {
	resizeImages();
};

function resizeImages() {
	/* Zmenšení obrázků a textů prodle velikosti okna */
	var questionContainer = $('.question:has(.question-attachment-img)');
	var usableHeight = window.innerHeight - 190;

	for (var i = 0; i < questionContainer.length; i++) {
		var paragraph = $($(questionContainer[i]).find("p")[0]);
		var image = $($(questionContainer[i]).find('.question-attachment-img')[0]);

		if ($(questionContainer[i]).height() > usableHeight) {
			var resizePercentage = usableHeight / $(questionContainer[i]).height();
			if (paragraph.height()) {
				var originalParagraphHeight = paragraph.height();
				var originalFontSize = paragraph.css("font-size").slice(0, -2);

				for (var j = originalFontSize; j >= 0; j--) {
					paragraph.css("font-size", j + "px");
					paragraph.css("line-height", (j + 4) + "px");

					if (paragraph.height() < originalParagraphHeight * resizePercentage) {
						break;
					}
				}
				image.css("height", image.height() * resizePercentage + "px");
			}
		} else {
			if (paragraph[0] && paragraph[0]['className'] !== 'to-hide'){
				image.removeAttr('style');
				paragraph.removeAttr('style');
			}
		}
	}
}

$(document).ready(function() {
	$('#fullpage').fullpage({
		loopHorizontal: false,
		afterLoad: function(anchorLink, index) {
			$('.moveToTextBox').val(1);
		},
		afterSlideLoad: function(anchorLink, index, slideAnchor, slideIndex) {

			$(".slide.fp-slide.active .question.iknow .item-hide:not(.was-hidden)").each(function() {
				$(this).addClass("was-hidden");
			});

			$(".slide.fp-slide .question.iknow .was-hidden:not(.item-hide)").each(function() {
				$(this).addClass("is-hidden");
			});

			$(".slide.fp-slide.active .question.iknow .is-hidden").each(function() {
				$(this).addClass("item-hide");
				$(this).removeClass("is-hidden");
			});

			//prepare for iknow question
			if (isIKnowQuestion() && containHiddenSubQuestion()) {
				$('.fp-next').addClass('next-destroyed');
				$('.next-destroyed').removeClass('fp-next');
				$('.next-destroyed').removeClass('fp-controlArrow');
			}

			$('.moveToTextBox').val(slideIndex + 1);
			const searchedString = 'observation';

			if (isNaN(slideAnchor) && slideAnchor.indexOf(searchedString) !== -1 ){

				let questionId = slideAnchor.split('-')[1];

				let questionCollection = document.querySelectorAll('#observationQuestion' + questionId);

				let question = questionCollection[0].children[1];
				let img = questionCollection[0].children[2];
				let note = questionCollection[0].children[3];
				let counter = document.querySelectorAll('.countdown' + questionId);
				let hourglass = document.querySelectorAll('#hourglass' + questionId);
				var doUpdate = function() {
					$('.countdown' + questionId).each(function() {
						var count = parseInt($(this).html());
						if (count !== 0) {
							$(this).html(count - 1);
						}
						else{
							img.style.display = "none";
							note.style.display = "none";
							counter[0].style.display = "none";
							question.style.display = "block";
							hourglass[0].style.display = "none";
						}
					});
				};

				setInterval(doUpdate, 1000);
			}

			if (isNaN(slideAnchor) && slideAnchor.indexOf('observation') !== -1){
				let questionId = slideAnchor.split('-')[1];

				const question = $('#' + questionId).data('question');
				const topic = $('#' + questionId).data('topic');
				let title = $('#' + questionId);


				let doUpdate = function() {
					if (title.html() === topic){
						title.html(question);
					}
					else{
						title.html(topic);
					}
				};

				setInterval(doUpdate, 15000);
			}
			else if(isNaN(slideAnchor) && slideAnchor.indexOf('normal') !== -1){
				let questionId = slideAnchor.split('-')[1];

				const question = $('#' + questionId).data('question');
				const topic = $('#' + questionId).data('topic');
				let title = $('#' + questionId);


				let doUpdate = function() {
					if (title.html() === topic){
						title.html(question);
					}
					else{
						title.html(topic);
					}
				};

				setInterval(doUpdate, 15000);
			}

			var $slide = $('#' + slideAnchor);
			if (isNaN(slideAnchor) && slideAnchor.indexOf('timer') !== -1 && $slide.data('status') !== 'inprogress'){
				var keySlide = slideAnchor.split('-')[1];
				$.fn.timer = function( callback ) {
					callback = callback || function() {};
					return this.each(function() {
						var $timer = $( this ),
							$minutesEl = $timer.find( '.minutes' ),
							$secondsEl = $timer.find( '.seconds' ),
							interval = 1000,
							timer = null,
							start = 60,
							minutesText = $minutesEl.text(),
							minutes = ( minutesText[0] == '0' ) ? minutesText[1] : minutesText[0],
							m = Number( minutes );

						timer = setInterval(function() {
							start--;
							if( start == 0 ) {
								start = 60;

								$secondsEl.text( '0' );

								m--;

								if( m == 0 ) {
									clearInterval( timer );
									$minutesEl.text( '0' );
									callback();

								}
							} else {

								$secondsEl.text( start.toString() );

								if( minutes.length == 2 ) {
									$minutesEl.text( m.toString() );
								} else {
									if( m == 1 ) {
										$minutesEl.text( '0' );
									} else {
										$minutesEl.text( m.toString() );
									}
								}

							}

						}, interval);

					});

				};
				$('#' + slideAnchor).timer(function() {
					document.getElementById( 'timer-beep-' + keySlide).volume = 0.5;
					document.getElementById( 'timer-beep-' + keySlide).play();
				});
				$slide.data('status', 'inprogress');
				function progress(timeleft, timetotal, $element) {
					var progressBarWidth = timeleft * $element.width() / timetotal;
					$element.find('span').animate({ width: progressBarWidth }, 500);
					if(timeleft > 0) {
						setTimeout(function() {
							progress(timeleft - 1, timetotal, $element);
						}, 1000);
					}
				}
				progress(60, 60, $('#progressBar-' + keySlide));
			}

		},
	});

	$('.moveTo').on('click', function() {
		$.fn.fullpage.moveTo(0, $('.moveToTextBox').val() - 1);
	});

	$('.section').each(function(i) {
		slideCounts(i);
	});

	function slideCounts(i) {
		var elm = $('.section').eq(i);
		var total = elm.find('.slide').length;
		var current = elm.find('.active').index();
		current++;
		elm.find('.sumCount').html('/' + total);
	}


	function isIKnowQuestion() {
		return $('.active > .fp-tableCell > .question').hasClass('iknow');
	}

	function containHiddenSubQuestion() {
		return !($('.active > .fp-tableCell > .question .item-hide').length === 0);
	}

	function showSubQuestion() {
		let destroyedItem = $('.next-destroyed');

		let hiddenSubQuestion = $('.active > .fp-tableCell > .question .item-hide');

		//prevent for stuck in iknow question when is used moveTo between pages
		if (!containHiddenSubQuestion() && destroyedItem.length > 0) {
			$.fn.fullpage.moveSlideRight();
		}

		//set back default class for fullpage.js
		if (!containHiddenSubQuestion()) {
			destroyedItem.addClass('fp-next');
			destroyedItem.addClass('fp-controlArrow');
			destroyedItem.removeClass('next-destroyed');
		}

		hiddenSubQuestion.first().removeClass('item-hide');
	}

	//iterate trought hidden iknow questions by arrows
	$(document).on('click', '.next-destroyed', function($e) {

		if (!checkForIknowBehind()) {
			let slideItem = $('#fullpage > div > div:first-child');

			//slide next if are keys used as last for slide
			if ($('.fp-next').hasClass('next-destroyed')) {
				slideItem.addClass('fp-slides');
				$.fn.fullpage.moveSlideRight();
			} else {

				showSubQuestion();

				//slide to next question from last subquestion
				if (isIKnowQuestion() && !containHiddenSubQuestion() && $('.fp-next').hasClass('fp-controlArrow')) {
					slideItem.addClass('fp-slides');
					$.fn.fullpage.moveSlideRight();
				}
			}
		} else {
			$.fn.fullpage.moveSlideRight();
		}
	});

	//iterate trought hidden iknow questions by arrows keys
	document.onkeydown = function(e) {

		let destroyedItem = $('.next-destroyed');
		let slideItem = $('#fullpage > div > div:first-child');

		switch (e.which) {
			case 33: // pageUp
			case 37: // leftArrow
				//in case of slide to left in iknow question
				destroyedItem.addClass('fp-next');
				destroyedItem.addClass('fp-controlArrow');
				slideItem.addClass('fp-slides');
				$.fn.fullpage.moveSlideLeft();
				break;

			case 34: // pageDown
				$.fn.fullpage.moveSlideRight();
				break;

			case 39: // rightArrow
				checkArrowSlide();
				break;

			default:
				return;// exit this handler for other keys
		}
	};

	function checkArrowSlide() {

		let destroyedItem = $('.next-destroyed');
		let slideItem = $('#fullpage > div > div:first-child');

		if (!checkForIknowBehind()) {

			if (isIKnowQuestion() && containHiddenSubQuestion()) {

				slideItem.removeClass('fp-slides');

				if (!(slideItem.hasClass('fp-slides'))) {
					showSubQuestion();
				}
			}

			//slide at last subquestion
			if (isIKnowQuestion() && !containHiddenSubQuestion() && $('.fp-next').hasClass('fp-controlArrow')) {
				destroyedItem.removeClass('next-destroyed');
				slideItem.addClass('fp-slides');
			}

			//prepare for move at before last subquestion
			if (isIKnowQuestion() && !containHiddenSubQuestion() && destroyedItem.length > 0) {
				destroyedItem.addClass('fp-next');
				destroyedItem.addClass('fp-controlArrow');
			}
		} else {
			$.fn.fullpage.moveSlideRight();
		}
	}

	//in case of slide to left in iknow question
	$(document).on('click', '.fp-prev', function($e) {
		let slideItem = $('#fullpage > div > div:first-child');

		if(!slideItem.hasClass('fp-slides')){
			slideItem.addClass('fp-slides');
			$.fn.fullpage.moveSlideLeft();
		}
	});

	// prevents to show iknow subquestions before the appointed time
	function checkForIknowBehind() {
		return ($('.fp-table.active').prev().prev().find('.item-hide').length > 0);
	}

	/* Dark theme switcher */
	$(".js-toggle-dark").on("click", function() {
		$(this).toggleClass("is-active");
		$("body").toggleClass("dark");
	});
});
